<?php
namespace App\Models;

use App\Core\Model;
use PDO;

class Staff extends Model
{
    public function findByEmail(string $email): ?array
    {
        $stmt = $this->db->prepare('SELECT * FROM staff WHERE email = ? LIMIT 1');
        $stmt->execute([$email]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function findById(int $id): ?array
    {
        $stmt = $this->db->prepare('SELECT * FROM staff WHERE id = ?');
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function all(): array
    {
        return $this->db->query('SELECT id, name, email, role, created_at, is_active FROM staff ORDER BY id DESC')->fetchAll();
    }

    public function create(string $name, string $email, string $password, string $role): int
    {
        $stmt = $this->db->prepare('INSERT INTO staff (name, email, password, role, is_active, created_at) VALUES (?, ?, ?, ?, 1, NOW())');
        $stmt->execute([$name, $email, password_hash($password, PASSWORD_DEFAULT), $role]);
        return (int)$this->db->lastInsertId();
    }

    public function updateStatus(int $id, bool $active): void
    {
        $stmt = $this->db->prepare('UPDATE staff SET is_active = ? WHERE id = ?');
        $stmt->execute([$active ? 1 : 0, $id]);
    }

    public function delete(int $id): void
    {
        $stmt = $this->db->prepare('DELETE FROM staff WHERE id = ?');
        $stmt->execute([$id]);
    }

    public function performance(): array
    {
        $sql = 'SELECT s.id, s.name, s.role,
                (SELECT COUNT(*) FROM tickets t WHERE t.assigned_staff_id = s.id) AS tickets_assigned,
                (SELECT COUNT(*) FROM tickets t WHERE t.assigned_staff_id = s.id AND t.status=\"closed\") AS tickets_closed,
                (SELECT COUNT(*) FROM messages m WHERE m.sender IN (\"staff\",\"admin\") AND m.created_at >= CURDATE() AND m.ticket_id IN (SELECT id FROM tickets WHERE assigned_staff_id = s.id)) AS replies_today
                FROM staff s ORDER BY s.role DESC, s.id DESC';
        return $this->db->query($sql)->fetchAll();
    }
}
