<?php
namespace App\Models;

use App\Core\Model;

class Setting extends Model
{
    public function get(string $key, $default = null)
    {
        $stmt = $this->db->prepare('SELECT value FROM settings WHERE `key` = ? LIMIT 1');
        $stmt->execute([$key]);
        $row = $stmt->fetch();
        return $row ? $row['value'] : $default;
    }

    public function set(string $key, string $value): void
    {
        $stmt = $this->db->prepare('INSERT INTO settings (`key`, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value)');
        $stmt->execute([$key, $value]);
    }

    public function all(): array
    {
        return $this->db->query('SELECT * FROM settings')->fetchAll();
    }
}
