<?php
namespace App\Models;

use App\Core\Model;
use PDO;

class Payment extends Model
{
    public function create(int $userId, float $amount, string $status = 'pending', ?string $providerId = null): int
    {
        $stmt = $this->db->prepare('INSERT INTO payments (user_id, amount, status, provider_id, created_at) VALUES (?, ?, ?, ?, NOW())');
        $stmt->execute([$userId, $amount, $status, $providerId]);
        return (int)$this->db->lastInsertId();
    }

    public function updateStatus(int $id, string $status): void
    {
        $stmt = $this->db->prepare('UPDATE payments SET status = ? WHERE id = ?');
        $stmt->execute([$status, $id]);
    }

    public function revenueToday(): float
    {
        $stmt = $this->db->query("SELECT IFNULL(SUM(amount),0) FROM payments WHERE status='paid' AND DATE(created_at)=CURDATE()");
        return (float)$stmt->fetchColumn();
    }

    public function revenueMonthly(): float
    {
        $stmt = $this->db->query("SELECT IFNULL(SUM(amount),0) FROM payments WHERE status='paid' AND DATE_FORMAT(created_at,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')");
        return (float)$stmt->fetchColumn();
    }

    public function all(int $limit = 100): array
    {
        $stmt = $this->db->prepare('SELECT p.*, u.username FROM payments p LEFT JOIN users u ON u.id = p.user_id ORDER BY p.id DESC LIMIT :limit');
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
