<?php
namespace App\Models;

use App\Core\Model;
use PDO;

class Message extends Model
{
    public function add(int $ticketId, string $sender, string $message, string $type = 'text'): void
    {
        $stmt = $this->db->prepare('INSERT INTO messages (ticket_id, sender, message, message_type, created_at) VALUES (?, ?, ?, ?, NOW())');
        $stmt->execute([$ticketId, $sender, $message, $type]);
        // if staff/admin replied, mark first_reply_at on ticket
        if ($sender !== 'user') {
            $ticketStmt = $this->db->prepare('UPDATE tickets SET first_reply_at = IFNULL(first_reply_at, NOW()) WHERE id = ?');
            $ticketStmt->execute([$ticketId]);
        }
    }

    public function listByTicket(int $ticketId): array
    {
        $stmt = $this->db->prepare('SELECT * FROM messages WHERE ticket_id = ? ORDER BY id ASC');
        $stmt->execute([$ticketId]);
        return $stmt->fetchAll();
    }

    public function countToday(): int
    {
        $stmt = $this->db->query('SELECT COUNT(*) FROM messages WHERE DATE(created_at) = CURDATE()');
        return (int)$stmt->fetchColumn();
    }
}
