<?php
namespace App\Core;

class Helper
{
    public static function sanitize(string $value): string
    {
        return htmlspecialchars(trim($value), ENT_QUOTES, 'UTF-8');
    }

    public static function randomCode(int $length = 10): string
    {
        return substr(bin2hex(random_bytes($length)), 0, $length);
    }

    public static function telegramApi(string $method, array $params): array
    {
        $token = $_ENV['TELEGRAM_BOT_TOKEN'];
        $url = "https://api.telegram.org/bot{$token}/{$method}";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        $response = curl_exec($ch);
        if ($response === false) {
            return ['ok' => false, 'description' => curl_error($ch)];
        }
        curl_close($ch);
        return json_decode($response, true) ?: ['ok' => false, 'description' => 'Invalid response'];
    }

    public static function sendTelegramMessage(string $telegramId, string $text, ?int $replyTo = null): void
    {
        self::telegramApi('sendMessage', [
            'chat_id' => $telegramId,
            'text' => $text,
            'parse_mode' => 'HTML',
            'reply_to_message_id' => $replyTo
        ]);
    }
}
