<?php
namespace App\Core;

use App\Models\Staff;

class Auth
{
    public static function attempt(string $email, string $password): bool
    {
        $staffModel = new Staff();
        $user = $staffModel->findByEmail($email);
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['staff_id'] = $user['id'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['last_activity'] = time();
            return true;
        }
        return false;
    }

    public static function check(): bool
    {
        $timeout = (int)($_ENV['SESSION_LIFETIME'] ?? 1800);
        if (!empty($_SESSION['staff_id'])) {
            if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout) {
                self::logout();
                return false;
            }
            $_SESSION['last_activity'] = time();
            return true;
        }
        return false;
    }

    public static function logout(): void
    {
        session_unset();
        session_destroy();
    }

    public static function user(): ?array
    {
        if (!self::check()) {
            return null;
        }
        $staffModel = new Staff();
        return $staffModel->findById((int)$_SESSION['staff_id']);
    }

    public static function requireRole(array $roles): void
    {
        if (!self::check() || !in_array($_SESSION['role'], $roles, true)) {
            header('Location: /admin/login.php');
            exit;
        }
    }
}
