<?php
use Dotenv\Dotenv;

require_once __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv::createImmutable(dirname(__DIR__));
$dotenv->safeLoad();

// Security: enforce HTTPS in production
if (($_ENV['APP_ENV'] ?? 'production') === 'production' && (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== 'on')) {
    // comment out if behind load balancer and handled elsewhere
}

// Session configuration
$sessionName = $_ENV['SESSION_NAME'] ?? 'infobot_session';
$sessionLifetime = (int)($_ENV['SESSION_LIFETIME'] ?? 1800);

session_name($sessionName);
session_set_cookie_params([
    'lifetime' => $sessionLifetime,
    'path' => '/',
    'domain' => '',
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => true,
    'samesite' => 'Lax'
]);
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Autoload classes from core/models/controllers already registered in composer.json

