<?php
require_once __DIR__ . '/../config/config.php';

use App\Models\User;
use App\Models\Ticket;
use App\Models\Message;
use App\Models\Payment;
use App\Core\Helper;

$input = file_get_contents('php://input');
$update = json_decode($input, true);

// basic secret check
$secret = $_GET['secret'] ?? '';
if ($secret !== ($_ENV['TELEGRAM_WEBHOOK_SECRET'] ?? '')) {
    http_response_code(401);
    exit('unauthorized');
}

if (!$update || !isset($update['message'])) {
    exit('ok');
}

$message = $update['message'];
$chatId = (string)$message['from']['id'];
$username = $message['from']['username'] ?? '';
$firstName = $message['from']['first_name'] ?? '';
$lastName = $message['from']['last_name'] ?? '';
$text = $message['text'] ?? '';
$messageType = isset($message['photo']) ? 'photo' : (isset($message['document']) ? 'document' : 'text');
$payload = $text;
if ($messageType === 'photo') {
    $photos = $message['photo'];
    $payload = end($photos)['file_id'];
} elseif ($messageType === 'document') {
    $payload = $message['document']['file_id'];
}

$userModel = new User();
$ticketModel = new Ticket();
$messageModel = new Message();

$user = $userModel->findByTelegramId($chatId);
if (!$user) {
    $userId = $userModel->create([
        'telegram_id' => $chatId,
        'username' => $username,
        'first_name' => $firstName,
        'last_name' => $lastName,
        'subscription_expiry' => null,
        'status' => 'active'
    ]);
    $user = $userModel->findByTelegramId($chatId);
}

if ($user['status'] === 'blocked') {
    Helper::sendTelegramMessage($chatId, 'Your account is blocked.');
    exit('blocked');
}

// subscription check
$active = $user['subscription_expiry'] && strtotime($user['subscription_expiry']) >= time();
if (!$active) {
    Helper::sendTelegramMessage($chatId, 'Subscription expired. Please renew to contact support.');
    exit('expired');
}

// get open ticket or create
$ticket = $ticketModel->findOpenByUser((int)$user['id']);
if (!$ticket) {
    $ticketId = $ticketModel->openTicket((int)$user['id']);
    $ticket = $ticketModel->findById($ticketId);
}

$messageModel->add((int)$ticket['id'], 'user', $payload, $messageType);

Helper::sendTelegramMessage($chatId, 'Your message has been received. Ticket: '.$ticket['ticket_code']);

// notify admin/staff via internal mechanism (could be email/slack).

exit('ok');
