(function(){
  const totalEl = document.getElementById('totalTickets');
  const openEl = document.getElementById('openTickets');
  if (!totalEl || !openEl) return;
  async function refresh(){
    try{
      const res = await fetch('/admin/api_stats.php', {credentials:'same-origin'});
      if(!res.ok) return;
      const data = await res.json();
      if(data.total) totalEl.textContent = data.total;
      if(data.open) openEl.textContent = data.open;
    }catch(e){console.error(e);}    
  }
  setInterval(refresh, 10000);
})();
