<?php
require_once __DIR__ . '/includes/header.php';
use App\Models\Ticket;
use App\Models\Message;
use App\Models\User;
use App\Core\CSRF;
use App\Core\Helper;

$ticketModel = new Ticket();
$messageModel = new Message();
$userModel = new User();

$code = $_GET['code'] ?? '';
$ticket = $ticketModel->findByCode($code);
if (!$ticket) {
    echo '<div class="alert alert-danger">Ticket not found</div>';
    require __DIR__ . '/includes/footer.php';
    exit;
}

// Only assigned staff or admin may view
if ($user['role'] === 'staff' && $ticket['assigned_staff_id'] && (int)$ticket['assigned_staff_id'] !== (int)$user['id']) {
    echo '<div class="alert alert-danger">Unauthorized</div>';
    require __DIR__ . '/includes/footer.php';
    exit;
}

$ticketUser = $userModel->findById($ticket['user_id']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::verify($_POST['csrf_token'] ?? '')) {
        echo '<div class="alert alert-danger">Invalid CSRF token</div>';
    } elseif (isset($_POST['assign_staff'])) {
        $staffId = (int)$_POST['staff_id'];
        $ticketModel->assign((int)$ticket['id'], $staffId);
        $ticket = $ticketModel->findByCode($code); // refresh
        echo '<div class="alert alert-success">Ticket assigned</div>';
    } elseif (isset($_POST['close_ticket'])) {
        $ticketModel->close((int)$ticket['id']);
        $ticket = $ticketModel->findByCode($code);
        echo '<div class="alert alert-success">Ticket closed</div>';
    } else {
        $text = trim($_POST['message'] ?? '');
        if ($text !== '') {
            $messageModel->add((int)$ticket['id'], $user['role'], $text);
            if ($ticketUser && $ticketUser['telegram_id']) {
                Helper::sendTelegramMessage($ticketUser['telegram_id'], "Reply to ticket {$ticket['ticket_code']}:\n".$text);
            }
            echo '<div class="alert alert-success">Reply sent</div>';
        }
    }
}
$messages = $messageModel->listByTicket((int)$ticket['id']);
?>
<div class="d-flex justify-content-between align-items-center mb-2">
  <h4>Ticket <?php echo htmlspecialchars($ticket['ticket_code']); ?></h4>
  <div>
    <?php if ($user['role'] === 'admin'): ?>
      <span class="badge bg-secondary">User ID: <?php echo $ticket['user_id']; ?></span>
    <?php endif; ?>
    <span class="badge bg-info">Status: <?php echo $ticket['status']; ?></span>
    <?php if ($ticket['status'] === 'open'): ?>
      <form method="post" class="d-inline">
        <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
        <input type="hidden" name="close_ticket" value="1">
        <button class="btn btn-sm btn-outline-danger">Close</button>
      </form>
    <?php endif; ?>
  </div>
</div>
<?php if ($user['role'] === 'admin'): ?>
<div class="mb-3">
  <form method="post" class="row g-2 align-items-end">
    <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
    <input type="hidden" name="assign_staff" value="1">
    <div class="col-auto"><label class="form-label mb-0">Assign to staff ID</label></div>
    <div class="col-auto"><input type="number" name="staff_id" class="form-control" required value="<?php echo $ticket['assigned_staff_id']; ?>"></div>
    <div class="col-auto"><button class="btn btn-outline-primary">Assign</button></div>
  </form>
</div>
<?php endif; ?>
<div class="card mb-3"><div class="card-body">
  <h6>Messages</h6>
  <?php foreach ($messages as $m): ?>
    <div class="mb-2">
      <strong><?php echo ucfirst($m['sender']); ?>:</strong>
      <div class="border rounded p-2 bg-light"><?php echo nl2br(htmlspecialchars($m['message'])); ?></div>
      <small class="text-muted"><?php echo $m['created_at']; ?></small>
    </div>
  <?php endforeach; ?>
</div></div>
<div class="card">
  <div class="card-body">
    <form method="post">
      <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
      <div class="mb-3">
        <label class="form-label">Reply</label>
        <textarea name="message" class="form-control" rows="4" required></textarea>
      </div>
      <button class="btn btn-primary" type="submit">Send Reply</button>
    </form>
  </div>
</div>
<?php require_once __DIR__ . '/includes/footer.php';
