<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\User;
use App\Core\CSRF;
use App\Core\Helper;

Auth::requireRole(['admin']);
$userModel = new User();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if (!CSRF::verify($_POST['csrf_token'] ?? '')) {
        echo '<div class="alert alert-danger">CSRF failed</div>';
    } else {
        $uid = (int)($_POST['user_id'] ?? 0);
        if ($_POST['action'] === 'block') {
            $userModel->updateStatus($uid, 'blocked');
        } elseif ($_POST['action'] === 'unblock') {
            $userModel->updateStatus($uid, 'active');
        } elseif ($_POST['action'] === 'set_expiry') {
            $expiry = Helper::sanitize($_POST['expiry']);
            $userModel->updateSubscription($uid, $expiry);
        }
    }
}
$users = $userModel->allWithPagination(200,0);
?>
<div class="d-flex justify-content-between mb-3">
  <h4>Users</h4>
  <div>
    <a class="btn btn-outline-secondary btn-sm" href="/admin/export_users.php">Export CSV</a>
  </div>
</div>
<table class="table table-bordered table-sm">
  <thead><tr><th>ID</th><th>Username</th><th>Telegram</th><th>Subscription</th><th>Status</th><th>Actions</th></tr></thead>
  <tbody>
    <?php foreach ($users as $u): ?>
      <tr>
        <td><?php echo $u['id']; ?></td>
        <td><?php echo htmlspecialchars($u['username']); ?></td>
        <td><?php echo htmlspecialchars($u['telegram_id']); ?></td>
        <td><?php echo $u['subscription_expiry']; ?></td>
        <td><?php echo $u['status']; ?></td>
        <td>
          <form method="post" class="d-inline">
            <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
            <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
            <?php if ($u['status'] !== 'blocked'): ?>
              <input type="hidden" name="action" value="block">
              <button class="btn btn-sm btn-danger">Block</button>
            <?php else: ?>
              <input type="hidden" name="action" value="unblock">
              <button class="btn btn-sm btn-success">Unblock</button>
            <?php endif; ?>
          </form>
          <form method="post" class="d-inline ms-1">
            <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
            <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
            <input type="hidden" name="action" value="set_expiry">
            <input type="date" name="expiry" value="<?php echo substr($u['subscription_expiry'],0,10); ?>" class="form-control form-control-sm d-inline" style="width: 170px;">
            <button class="btn btn-sm btn-outline-primary">Set Expiry</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/includes/footer.php';
