<?php
require_once __DIR__ . '/includes/header.php';
use App\Models\Ticket;
use App\Models\User;

$ticketModel = new Ticket();
$userModel = new User();

if ($user['role'] === 'admin') {
    $tickets = $ticketModel->listAll(100);
} else {
    $tickets = $ticketModel->listForStaff($user['id'], 100);
}
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Tickets</h4>
  <?php if ($user['role'] === 'admin'): ?><a href="/admin/export_tickets.php" class="btn btn-sm btn-outline-secondary">Export CSV</a><?php endif; ?>
</div>
<table class="table table-striped">
  <thead><tr><th>Code</th><th>Status</th><th>Assigned</th><th>Created</th><th></th></tr></thead>
  <tbody>
    <?php foreach ($tickets as $t): ?>
      <tr>
        <td><?php echo htmlspecialchars($t['ticket_code']); ?></td>
        <td><?php echo $t['status']; ?></td>
        <td><?php echo $t['assigned_staff_id'] ? ($t['staff_name'] ?? 'Staff #'.$t['assigned_staff_id']) : 'Unassigned'; ?></td>
        <td><?php echo $t['created_at']; ?></td>
        <td><a href="/admin/view_ticket.php?code=<?php echo urlencode($t['ticket_code']); ?>" class="btn btn-sm btn-primary">View</a></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/includes/footer.php';
