<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\Staff;
use App\Core\CSRF;
use App\Core\Helper;

Auth::requireRole(['admin']);
$staffModel = new Staff();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::verify($_POST['csrf_token'] ?? '')) {
        $message = 'CSRF failed';
    } else {
        $name = Helper::sanitize($_POST['name'] ?? '');
        $email = Helper::sanitize($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';
        $role = $_POST['role'] ?? 'staff';
        $staffModel->create($name, $email, $password, $role);
        $message = 'Staff created';
    }
}

$staff = $staffModel->all();
?>
<div class="row">
  <div class="col-md-6">
    <h4>Staff</h4>
    <?php if ($message): ?><div class="alert alert-info"><?php echo $message; ?></div><?php endif; ?>
    <table class="table table-bordered table-sm">
      <thead><tr><th>Name</th><th>Email</th><th>Role</th><th>Status</th></tr></thead>
      <tbody>
        <?php foreach ($staff as $s): ?>
          <tr><td><?php echo htmlspecialchars($s['name']); ?></td><td><?php echo htmlspecialchars($s['email']); ?></td><td><?php echo $s['role']; ?></td><td><?php echo $s['is_active'] ? 'Active' : 'Disabled'; ?></td></tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="col-md-6">
    <h4>Add Staff</h4>
    <form method="post">
      <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
      <div class="mb-2"><label class="form-label">Name</label><input name="name" class="form-control" required></div>
      <div class="mb-2"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
      <div class="mb-2"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
      <div class="mb-2"><label class="form-label">Role</label>
        <select name="role" class="form-select">
          <option value="staff">Staff</option>
          <option value="admin">Admin</option>
        </select>
      </div>
      <button class="btn btn-primary">Create</button>
    </form>
  </div>
</div>
<?php require_once __DIR__ . '/includes/footer.php';
