<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\Setting;
use App\Core\CSRF;
use App\Core\Helper;

Auth::requireRole(['admin']);
$settingModel = new Setting();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::verify($_POST['csrf_token'] ?? '')) {
        $message = 'CSRF failed';
    } else {
        $price = Helper::sanitize($_POST['subscription_price']);
        $days = (int)$_POST['subscription_days'];
        $settingModel->set('subscription_price', $price);
        $settingModel->set('subscription_days', (string)$days);
        $message = 'Settings updated';
    }
}
$currentPrice = $settingModel->get('subscription_price', $_ENV['SUBSCRIPTION_PRICE'] ?? '9.99');
$currentDays = $settingModel->get('subscription_days', $_ENV['SUBSCRIPTION_DAYS'] ?? '30');
?>
<h4>Settings</h4>
<?php if ($message): ?><div class="alert alert-info"><?php echo $message; ?></div><?php endif; ?>
<form method="post" class="row g-3">
  <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
  <div class="col-md-6">
    <label class="form-label">Subscription Price (USD)</label>
    <input name="subscription_price" class="form-control" value="<?php echo $currentPrice; ?>" required>
  </div>
  <div class="col-md-6">
    <label class="form-label">Subscription Duration (days)</label>
    <input name="subscription_days" type="number" class="form-control" value="<?php echo $currentDays; ?>" required>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Save</button>
  </div>
</form>
<?php require_once __DIR__ . '/includes/footer.php';
