<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\Payment;

Auth::requireRole(['admin']);
$paymentModel = new Payment();
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['payment_id'])) {
    if (!App\Core\CSRF::verify($_POST['csrf_token'] ?? '')) {
        $message = 'CSRF failed';
    } else {
        $paymentModel->updateStatus((int)$_POST['payment_id'], $_POST['status']);
        $message = 'Payment status updated';
    }
}
$payments = $paymentModel->all();
?>
<h4>Payments</h4>
<?php if ($message): ?><div class="alert alert-info"><?php echo $message; ?></div><?php endif; ?>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>User</th><th>Amount</th><th>Status</th><th>Provider ID</th><th>Date</th><th></th></tr></thead>
  <tbody>
    <?php foreach ($payments as $p): ?>
      <tr>
        <td><?php echo $p['id']; ?></td>
        <td><?php echo htmlspecialchars($p['username']); ?></td>
        <td>$<?php echo number_format($p['amount'],2); ?></td>
        <td><?php echo $p['status']; ?></td>
        <td><?php echo htmlspecialchars($p['provider_id']); ?></td>
        <td><?php echo $p['created_at']; ?></td>
        <td>
          <form method="post" class="d-inline">
            <input type="hidden" name="csrf_token" value="<?php echo App\Core\CSRF::token(); ?>">
            <input type="hidden" name="payment_id" value="<?php echo $p['id']; ?>">
            <select name="status" class="form-select form-select-sm d-inline" style="width:130px;">
              <option value="pending" <?php echo $p['status']==='pending'?'selected':''; ?>>pending</option>
              <option value="paid" <?php echo $p['status']==='paid'?'selected':''; ?>>paid</option>
              <option value="failed" <?php echo $p['status']==='failed'?'selected':''; ?>>failed</option>
            </select>
            <button class="btn btn-sm btn-outline-primary">Save</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<a href="/admin/export_revenue.php" class="btn btn-outline-secondary btn-sm">Export Revenue CSV</a>
<?php require_once __DIR__ . '/includes/footer.php';
