<?php
require_once __DIR__ . '/../../config/config.php';
use App\Core\Auth;
use App\Core\CSRF;

if (!Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}
$user = Auth::user();
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Infobot Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="/admin/dashboard.php">Infobot</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="/admin/dashboard.php">Dashboard</a></li>
        <?php if ($user['role'] === 'admin'): ?>
        <li class="nav-item"><a class="nav-link" href="/admin/users.php">Users</a></li>
        <li class="nav-item"><a class="nav-link" href="/admin/staff.php">Staff</a></li>
        <li class="nav-item"><a class="nav-link" href="/admin/payments.php">Payments</a></li>
        <li class="nav-item"><a class="nav-link" href="/admin/settings.php">Settings</a></li>
        <li class="nav-item"><a class="nav-link" href="/admin/broadcast.php">Broadcast</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="/admin/tickets.php">Tickets</a></li>
      </ul>
      <span class="navbar-text text-white me-3">Logged in as <?php echo htmlspecialchars($user['name']); ?> (<?php echo $user['role']; ?>)</span>
      <a class="btn btn-outline-light" href="/admin/logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container mt-4">
