<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\Ticket;

Auth::requireRole(['admin']);
$ticketModel = new Ticket();
$tickets = $ticketModel->listAll(5000);
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="tickets.csv"');
$out = fopen('php://output', 'w');
fputcsv($out, ['ID','Code','User','Assigned Staff','Status','Created']);
foreach ($tickets as $t) {
    fputcsv($out, [$t['id'],$t['ticket_code'],$t['user_id'],$t['assigned_staff_id'],$t['status'],$t['created_at']]);
}
fclose($out);
exit;
