<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Models\Payment;

Auth::requireRole(['admin']);
$paymentModel = new Payment();
$payments = $paymentModel->all(10000);
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="revenue.csv"');
$out = fopen('php://output', 'w');
fputcsv($out, ['ID','User','Amount','Status','Provider ID','Date']);
foreach ($payments as $p) {
    fputcsv($out, [$p['id'],$p['username'],$p['amount'],$p['status'],$p['provider_id'],$p['created_at']]);
}
fclose($out);
exit;
