<?php
require_once __DIR__ . '/includes/header.php';
use App\Models\User;
use App\Models\Ticket;
use App\Models\Message;
use App\Models\Payment;
use App\Models\Staff;

$userModel = new User();
$ticketModel = new Ticket();
$messageModel = new Message();
$paymentModel = new Payment();
$staffModel = new Staff();

$stats = [
    'total_users' => $userModel->count(),
    'active_subs' => $userModel->countActiveSubscriptions(),
    'expired_subs' => $userModel->countExpiredSubscriptions(),
    'blocked' => $userModel->countBlocked(),
];
$ticketStats = $ticketModel->stats();
$messagesToday = $messageModel->countToday();
$revenueToday = $paymentModel->revenueToday();
$revenueMonthly = $paymentModel->revenueMonthly();
$avgReply = $ticketModel->avgReplySeconds();
$avgResolution = $ticketModel->avgResolutionSeconds();
$staffPerf = $staffModel->performance();

?>
<?php if ($user['role'] === 'admin'): ?>
  <div class="row g-3">
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Total Users</h6><h3><?php echo $stats['total_users']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Active Subs</h6><h3><?php echo $stats['active_subs']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Expired Subs</h6><h3><?php echo $stats['expired_subs']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Blocked Users</h6><h3><?php echo $stats['blocked']; ?></h3></div></div></div>
  </div>
  <div class="row g-3 mt-1">
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Total Tickets</h6><h3 id="totalTickets"><?php echo $ticketStats['total']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Open Tickets</h6><h3 id="openTickets"><?php echo $ticketStats['open']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Closed Tickets</h6><h3><?php echo $ticketStats['closed']; ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Messages Today</h6><h3><?php echo $messagesToday; ?></h3></div></div></div>
  </div>
  <div class="row g-3 mt-1">
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Revenue Today</h6><h3>$<?php echo number_format($revenueToday,2); ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Monthly Revenue</h6><h3>$<?php echo number_format($revenueMonthly,2); ?></h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Avg Reply Time</h6><h3><?php echo round($avgReply/60,1); ?> min</h3></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Avg Resolution</h6><h3><?php echo round($avgResolution/60,1); ?> min</h3></div></div></div>
  </div>
  <div class="row mt-3">
    <div class="col-lg-8">
      <div class="card">
        <div class="card-body">
          <h6>Tickets Overview</h6>
          <canvas id="ticketsChart" height="120"></canvas>
        </div>
      </div>
    </div>
    <div class="col-lg-4">
      <div class="card">
        <div class="card-body">
          <h6>Staff Performance</h6>
          <table class="table table-sm">
            <thead><tr><th>Name</th><th>Assigned</th><th>Closed</th><th>Replies Today</th></tr></thead>
            <tbody>
            <?php foreach ($staffPerf as $s): ?>
              <tr><td><?php echo htmlspecialchars($s['name']); ?></td><td><?php echo $s['tickets_assigned']; ?></td><td><?php echo $s['tickets_closed']; ?></td><td><?php echo $s['replies_today']; ?></td></tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
  <script>
  const ctx = document.getElementById('ticketsChart');
  new Chart(ctx, {
      type: 'doughnut',
      data: {
          labels: ['Open','Closed'],
          datasets: [{data: [<?php echo $ticketStats['open']; ?>, <?php echo $ticketStats['closed']; ?>], backgroundColor:['#0d6efd','#6c757d']}]
      }
  });
  </script>
<?php else: // staff view ?>
  <?php\n+    // staff-specific stats\n+    $staffTickets = $ticketModel->listForStaff($user['id'], 10000);\n+    $open = 0; $closed = 0;\n+    foreach ($staffTickets as $st) { $st['status']==='open' ? $open++ : $closed++; }\n+  ?>\n   <div class=\"row g-3\">\n-    <div class=\"col-md-4\"><div class=\"card\"><div class=\"card-body\"><h6>Tickets Assigned</h6><h3><?php echo $ticketStats['total']; ?></h3></div></div></div>\n-    <div class=\"col-md-4\"><div class=\"card\"><div class=\"card-body\"><h6>Open Tickets</h6><h3><?php echo $ticketStats['open']; ?></h3></div></div></div>\n+    <div class=\"col-md-4\"><div class=\"card\"><div class=\"card-body\"><h6>Tickets Assigned</h6><h3><?php echo count($staffTickets); ?></h3></div></div></div>\n+    <div class=\"col-md-4\"><div class=\"card\"><div class=\"card-body\"><h6>Open Tickets</h6><h3><?php echo $open; ?></h3></div></div></div>\n     <div class=\"col-md-4\"><div class=\"card\"><div class=\"card-body\"><h6>Replies Today</h6><h3><?php echo $messagesToday; ?></h3></div></div></div>\n   </div>\n <?php endif; ?>\n*** End Patch
  <div class="row g-3">
    <div class="col-md-4"><div class="card"><div class="card-body"><h6>Tickets Assigned</h6><h3><?php echo $ticketStats['total']; ?></h3></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><h6>Open Tickets</h6><h3><?php echo $ticketStats['open']; ?></h3></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><h6>Replies Today</h6><h3><?php echo $messagesToday; ?></h3></div></div></div>
  </div>
<?php endif; ?>

<?php require_once __DIR__ . '/includes/footer.php';
