<?php
require_once __DIR__ . '/includes/header.php';
use App\Core\Auth;
use App\Core\CSRF;
use App\Models\User;
use App\Core\Helper;

Auth::requireRole(['admin']);
$userModel = new User();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::verify($_POST['csrf_token'] ?? '')) {
        $message = 'CSRF failed';
    } else {
        $text = trim($_POST['message'] ?? '');
        if ($text !== '') {
            $users = $userModel->allWithPagination(10000,0);
            foreach ($users as $u) {
                if ($u['status'] === 'active') {
                    Helper::sendTelegramMessage($u['telegram_id'], $text);
                }
            }
            $message = 'Broadcast sent to active users';
        }
    }
}
?>
<h4>Broadcast Message</h4>
<?php if ($message): ?><div class="alert alert-info"><?php echo $message; ?></div><?php endif; ?>
<form method="post">
  <input type="hidden" name="csrf_token" value="<?php echo CSRF::token(); ?>">
  <div class="mb-3">
    <label class="form-label">Message</label>
    <textarea name="message" class="form-control" rows="4" required></textarea>
  </div>
  <button class="btn btn-primary">Send Broadcast</button>
</form>
<?php require_once __DIR__ . '/includes/footer.php';
