# Infobot Telegram Support Relay

Production-ready Telegram support relay with subscription gating, ticketing, admin/staff panels, and analytics.

## Requirements
- PHP 8.0+
- MySQL 5.7/8
- Composer

## Setup
1. `composer install`
2. Create database and import `database.sql`.
3. Copy `.env` and set values (DB, TELEGRAM_BOT_TOKEN, TELEGRAM_WEBHOOK_SECRET).
4. Set webroot to project folder. Ensure `/bot/webhook.php` is reachable via HTTPS.
5. Set correct permissions for `uploads/` if used.
6. Configure a cron (every 15 min) to expire subs if you add automation: `UPDATE users SET subscription_expiry=NULL WHERE subscription_expiry < NOW();`

## Webhook
Set Telegram webhook (replace URL & secret):
```
https://api.telegram.org/bot<token>/setWebhook?url=https://yourdomain.com/bot/webhook.php?secret=YOURSECRET
```

## Admin Login
- Seed admin: email `admin@example.com`, password `admin123` (change after first login).

## Security
- HTTPS recommended.
- CSRF tokens on forms, PDO prepared statements, password hashing, role checks, session timeout.

## Folder Map
- `bot/webhook.php` Telegram webhook handler
- `admin/*.php` admin/staff panels
- `models/` data access
- `core/` shared classes (DB, Auth, CSRF, Helper)
- `config/` bootstrap and DB loader

## Notes
- Staff cannot see user PII; only ticket code is shown.
- Broadcast tool sends to active users only.
- CSV exports for users, tickets, revenue.
- Chart.js used for dashboard.
